/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.common.upload;

import com.uqm.crashsight.symtabtool.common.upload.a;
import com.uqm.crashsight.symtabtool.common.utils.Utils;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SymtabFileUploader {
    public static final String CRASHSIGHT_VERSION_2X = "2.x";

    public static boolean uploadSymtabFile(UploadInfo uploadInfo) {
        if (!uploadInfo.validate()) {
            com.uqm.crashsight.symtabtool.common.utils.a.b("Can not upload symtab file.", new Object[0]);
            return false;
        }
        com.uqm.crashsight.symtabtool.common.utils.a.b("Upload symbol file: %s", uploadInfo.fileName);
        for (int i2 = 0; i2 < 2; ++i2) {
            boolean bl2;
            Object object;
            if (i2 > 0) {
                Utils.sleep(3000L);
            }
            Object object2 = object = uploadInfo;
            Serializable serializable = new StringBuilder();
            if (!((UploadInfo)object2).isRqd) {
                ((StringBuilder)serializable).append(((UploadInfo)object2).uploadUrl == null ? "" : ((UploadInfo)object2).uploadUrl);
            }
            ((StringBuilder)serializable).append("?");
            ((StringBuilder)serializable).append(Utils.urlEncodeString("app_key"));
            ((StringBuilder)serializable).append("=");
            ((StringBuilder)serializable).append(Utils.urlEncodeString(((UploadInfo)object2).appKey));
            ((StringBuilder)serializable).append("&");
            ((StringBuilder)serializable).append(Utils.urlEncodeString("app_id"));
            ((StringBuilder)serializable).append("=");
            ((StringBuilder)serializable).append(Utils.urlEncodeString(((UploadInfo)object2).appId));
            object2 = ((StringBuilder)serializable).toString();
            com.uqm.crashsight.symtabtool.common.utils.a.b("upload url: " + (String)object2, new Object[0]);
            serializable = new HashMap<String, String>();
            serializable.put("api_version", "1");
            serializable.put("app_id", ((UploadInfo)object).appId);
            serializable.put("app_key", ((UploadInfo)object).appKey);
            serializable.put("symbolType", ((UploadInfo)object).symbolType);
            serializable.put("fileName", ((UploadInfo)object).fileName);
            if (((UploadInfo)object).appPackage != null) {
                serializable.put("bundleId", ((UploadInfo)object).appPackage);
            }
            if (((UploadInfo)object).appVersion != null) {
                serializable.put("productVersion", ((UploadInfo)object).appVersion);
            }
            int n2 = 1;
            if (((UploadInfo)object).symbolType.equals("1")) {
                if (((UploadInfo)object).appChannel != null) {
                    serializable.put("channel", ((UploadInfo)object).appChannel);
                }
                serializable.put("productVersion", ((UploadInfo)object).appVersion);
                n2 = 0;
            }
            if ((object = a.a((String)object2, true, ((UploadInfo)object).file, n2, (Map<String, String>)((Object)serializable))) != null) {
                com.uqm.crashsight.symtabtool.common.utils.a.c(((a.a)object).b, new Object[0]);
                bl2 = ((a.a)object).b.contains("\"code\":\"0\"") ? ((a.a)object).a == 200 : false;
            } else {
                bl2 = false;
            }
            if (!bl2) continue;
            com.uqm.crashsight.symtabtool.common.utils.a.b("Successfully uploaded.", new Object[0]);
            return true;
        }
        com.uqm.crashsight.symtabtool.common.utils.a.d("Failed to upload symtab file.", new Object[0]);
        return false;
    }

    public static class UploadInfo {
        public static final String SYMBOL_TYPE_JAVA = "1";
        public static final String SYMBOL_TYPE_IOS = "2";
        public static final String SYMBOL_TYPE_NATIVE = "3";
        public static final String SYMBOL_TYPE_WIN_ORI = "10";
        public static final String SYMBOL_TYPE_WIN_SYM = "12";
        public String appId = null;
        public String appKey = null;
        public String appChannel = null;
        public String appPackage = null;
        public String appVersion = null;
        public String symbolType = null;
        public String fileName = null;
        public String crashSightVersion = "2.x";
        public File file = null;
        public boolean isRqd = false;
        public String uploadUrl;

        public boolean validate() {
            if (this.appId == null) {
                com.uqm.crashsight.symtabtool.common.utils.a.c("Uploading info is missing: APP ID", new Object[0]);
                return false;
            }
            if (this.appKey == null) {
                com.uqm.crashsight.symtabtool.common.utils.a.c("Uploading info is missing: APP key", new Object[0]);
                return false;
            }
            if (this.symbolType == null) {
                com.uqm.crashsight.symtabtool.common.utils.a.c("Uploading info is missing: symbol type", new Object[0]);
                return false;
            }
            if (this.file == null) {
                com.uqm.crashsight.symtabtool.common.utils.a.c("Uploading info is missing: file", new Object[0]);
                return false;
            }
            if (this.fileName == null) {
                com.uqm.crashsight.symtabtool.common.utils.a.c("Uploading info is missing: file name", new Object[0]);
                return false;
            }
            if (this.crashSightVersion != null && this.crashSightVersion.equals(SymtabFileUploader.CRASHSIGHT_VERSION_2X)) {
                if (this.symbolType.equals(SYMBOL_TYPE_JAVA) && this.appVersion == null) {
                    com.uqm.crashsight.symtabtool.common.utils.a.c("Uploading info is missing: APP version", new Object[0]);
                    return false;
                }
                return true;
            }
            if (this.appPackage == null) {
                com.uqm.crashsight.symtabtool.common.utils.a.a();
                return false;
            }
            if (this.appVersion == null) {
                com.uqm.crashsight.symtabtool.common.utils.a.a();
                return false;
            }
            return true;
        }
    }
}

